class mark {

  ArrayList <mark> marks = new ArrayList <mark> ();

  mark parent_mark;

  utils u = new utils();
  Vec2D offset;

  String name;
  PImage mark_image;
  Vec2D local_origin;
  Vec2D global_origin;
  float speed = 1.0;
  String[] step_modes = {
    "forward", "backward", "bidirectional"
  };
  String step_mode = step_modes[2];

  boolean inherit_motion = true;
  boolean trail = false;
  boolean paused = false;

  int delay = 0;

  Vec2D current_position;
  Vec2D previous_position;
  float[][] steps;
  int i = 0;

  mark(String n) {
    name = n;
    global_origin = new Vec2D(0, 0);
  } 

  mark(String n, float[][] s, mark p, Vec2D o, Vec2D lo, boolean t, boolean pa, String ssm) {
    name = n;
    parent_mark = p;
    global_origin = o;
    local_origin = lo;
    paused = pa;
    current_position = lo;
    steps = s;
    trail = t;
    step_mode = ssm;
  } 

  //************
  //marks methods

  int pi;

  Vec2D step(String mode) {
    if (i >= 0 && i < steps.length && delay == steps[i][6]) {
      delay = 0;
      if (mode.equals("forward")) {
        if (i == steps.length-1) {
          i=0;
        }
        i++;
      }
      else if (mode.equals("backward")) {
        if (i == 0) {
          i=steps.length-1;
        }
        i--;
      }
      else if (mode.equals("bidirectional")) {
        if (i > pi && i < steps.length-1 || i == 0) {
          pi = i;
          i++;
        }
        else if (i < pi || i == steps.length-1) {
          pi = i;
          i--;
        }
      }
    }
    return new Vec2D(steps[i][0], steps[i][1]);
  }  

  void raise_mark(mark m) {
    if (m != root_mark) {
      int indexOfMarktoRaise = marks.indexOf(m);
      if (marks.size() > 0 && indexOfMarktoRaise < marks.size()-1) u.swap(marks, indexOfMarktoRaise+1, indexOfMarktoRaise);
    }
  }

  void lower_mark(mark m) {
    if (m != root_mark) {
      int indexOfMarktoLower = marks.indexOf(m);
      if (marks.size() > 0 && indexOfMarktoLower > 0) u.swap(marks, indexOfMarktoLower-1, indexOfMarktoLower);
    }
  }


  mark add_mark(mark m) {
    marks.add(m);
    m.parent_mark = this;
    return m;
  }

  mark next_mark() {
    mark m;
    if (parent_mark.marks.size() > 0) {
      int n = parent_mark.marks.indexOf(this)+1;
      if (n >= parent_mark.marks.size()) {
        n = 0;
      }
      return parent_mark.marks.get(n);
    } 
    else return root_mark;
  }

  mark prev_mark() {
    mark m;
    if (parent_mark.marks.size() >= 0) {
      int n = parent_mark.marks.indexOf(this)-1;
      if (n < 0) {
        n = parent_mark.marks.size()-1;
      }
      return parent_mark.marks.get(n);
    } 
    else return parent_mark;
  }  


  void move_mark(ArrayList[] mouse_distances) {
    if (this != root_mark) {
      mark closest_mark = closest_mark(this, mouse_distances);
      this.parent_mark.marks.remove(this);
      closest_mark.add_mark(selected_mark);
      selected_mark.local_origin = mark_to_mouse(this.parent_mark);
      offset = this.local_origin.sub(mouse_vector());
    }
  }

  void move_mark_lateral(String direction) {
    if (this != root_mark && parent_mark != root_mark) {
      parent_mark.marks.remove(this);
      if (direction == "next") {
        parent_mark = parent_mark.next_mark();
      }
      else if (direction == "prev") { 
        parent_mark = parent_mark.prev_mark();
      }
      parent_mark.add_mark(this);
    }
  }

  void move_mark_longitudinal(String direction) {
    if (direction == "descend") {
      if (this != root_mark && parent_mark.marks.get(0) != this) { 
        parent_mark.marks.remove(this);
        parent_mark = parent_mark.marks.get(0);
        parent_mark.add_mark(this);
        if (parent_mark.parent_mark == root_mark) {
          local_origin = mark_to_mouse(parent_mark);
        }
      }
    }
    else if (direction == "ascend") {
      if (this != root_mark) {
        parent_mark.marks.remove(this);
        parent_mark = parent_mark.parent_mark;
        parent_mark.add_mark(this);
        if (parent_mark == root_mark) {
          local_origin = mark_to_mouse(parent_mark);
        }
      }
    }
  }

  mark remove_from_parent() {

    parent_mark.marks.remove(this);

    for (mark new_child : marks) {
      parent_mark.add_mark(new_child);
      new_child.parent_mark = parent_mark;
      new_child.local_origin = new_child.local_origin.add(local_origin);
    }
    return parent_mark;
  } 

  int num_parents(mark m, int n) {
    if (m.parent_mark != m) {
      n+=1;
      return num_parents(m.parent_mark, n);
    }
    else return n;
  }
}

